/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.fabricators_of_create.porting_lib.models.ConcatenatedListView;
import io.github.fabricators_of_create.porting_lib.models.UnbakedGeometryHelper;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1093;
import net.minecraft.class_1100;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public class CompositeModel
implements IUnbakedGeometry<CompositeModel> {
    private final ImmutableMap<String, class_793> children;
    private final ImmutableList<String> itemPasses;

    public CompositeModel(ImmutableMap<String, class_793> children, ImmutableList<String> itemPasses) {
        this.children = children;
        this.itemPasses = itemPasses;
    }

    public class_1087 bake(class_793 context, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_806 overrides, class_2960 modelLocation, boolean isGui3d) {
        class_4730 particleLocation = context.method_24077("particle");
        class_1058 particle = spriteGetter.apply(particleLocation);
        class_4590 rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            modelState = UnbakedGeometryHelper.composeRootTransformIntoModelState((class_3665)modelState, (class_4590)rootTransform);
        }
        ImmutableMap.Builder bakedPartsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.children.entrySet()) {
            String name = (String)entry.getKey();
            if (!context.isComponentVisible(name, true)) continue;
            class_793 model = (class_793)entry.getValue();
            bakedPartsBuilder.put((Object)name, (Object)model.method_3446(baker, model, spriteGetter, modelState, modelLocation, true));
        }
        ImmutableMap bakedParts = bakedPartsBuilder.build();
        ImmutableList.Builder itemPassesBuilder = ImmutableList.builder();
        for (String name : this.itemPasses) {
            class_1087 model = (class_1087)bakedParts.get((Object)name);
            if (model == null) {
                throw new IllegalStateException("Specified \"" + name + "\" in \"item_render_order\", but that is not a child of this model.");
            }
            itemPassesBuilder.add((Object)model);
        }
        return new Baked(true, context.method_24298().method_24299(), context.method_3444(), particle, context.method_3443(), context.method_3440(baker, context), (ImmutableMap<String, class_1087>)bakedParts, (ImmutableList<class_1087>)itemPassesBuilder.build());
    }

    public void resolveParents(Function<class_2960, class_1100> modelGetter, class_793 context) {
        this.children.values().forEach(child -> child.method_45785(modelGetter));
    }

    public Set<String> getConfigurableComponentNames() {
        return this.children.keySet();
    }

    public static class Baked
    implements class_1087,
    FabricBakedModel {
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final class_1058 particle;
        private final class_806 overrides;
        private final class_809 transforms;
        private final ImmutableMap<String, class_1087> children;
        private final ImmutableList<class_1087> itemPasses;

        public Baked(boolean isGui3d, boolean isSideLit, boolean isAmbientOcclusion, class_1058 particle, class_809 transforms, class_806 overrides, ImmutableMap<String, class_1087> children, ImmutableList<class_1087> itemPasses) {
            this.children = children;
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isGui3d = isGui3d;
            this.isSideLit = isSideLit;
            this.particle = particle;
            this.overrides = overrides;
            this.transforms = transforms;
            this.itemPasses = itemPasses;
        }

        public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, class_5819 rand) {
            ArrayList<List> quadLists = new ArrayList<List>();
            for (Map.Entry entry : this.children.entrySet()) {
                quadLists.add(((class_1087)entry.getValue()).method_4707(state, side, rand));
            }
            return ConcatenatedListView.of(quadLists);
        }

        public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
            for (Map.Entry entry : this.children.entrySet()) {
                ((FabricBakedModel)entry.getValue()).emitBlockQuads(blockView, state, pos, randomSupplier, context);
            }
        }

        public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
            for (Map.Entry entry : this.children.entrySet()) {
                ((FabricBakedModel)entry.getValue()).emitItemQuads(stack, randomSupplier, context);
            }
        }

        public boolean method_4708() {
            return this.isAmbientOcclusion;
        }

        public boolean method_4712() {
            return this.isGui3d;
        }

        public boolean method_24304() {
            return this.isSideLit;
        }

        public boolean method_4713() {
            return false;
        }

        public class_1058 method_4711() {
            return this.particle;
        }

        public class_806 method_4710() {
            return this.overrides;
        }

        public class_809 method_4709() {
            return this.transforms;
        }

        public boolean isVanillaAdapter() {
            return false;
        }

        @Nullable
        public class_1087 getPart(String name) {
            return (class_1087)this.children.get((Object)name);
        }

        public static Builder builder(class_793 owner, boolean isGui3d, class_1058 particle, class_806 overrides, class_809 cameraTransforms) {
            return Baked.builder(owner.method_3444(), isGui3d, owner.method_24298().method_24299(), particle, overrides, cameraTransforms);
        }

        public static Builder builder(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, class_1058 particle, class_806 overrides, class_809 cameraTransforms) {
            return new Builder(isAmbientOcclusion, isGui3d, isSideLit, particle, overrides, cameraTransforms);
        }

        public static class Builder {
            private final boolean isAmbientOcclusion;
            private final boolean isGui3d;
            private final boolean isSideLit;
            private final List<class_1087> children = new ArrayList<class_1087>();
            private final List<class_777> quads = new ArrayList<class_777>();
            private final class_806 overrides;
            private final class_809 transforms;
            private class_1058 particle;

            private Builder(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, class_1058 particle, class_806 overrides, class_809 transforms) {
                this.isAmbientOcclusion = isAmbientOcclusion;
                this.isGui3d = isGui3d;
                this.isSideLit = isSideLit;
                this.particle = particle;
                this.overrides = overrides;
                this.transforms = transforms;
            }

            public void addLayer(class_1087 model) {
                this.flushQuads();
                this.children.add(model);
            }

            private void addLayer(List<class_777> quads) {
                class_1093.class_1094 modelBuilder = new class_1093.class_1094(this.isAmbientOcclusion, this.isSideLit, this.isGui3d, this.transforms, this.overrides).method_4747(this.particle);
                quads.forEach(arg_0 -> ((class_1093.class_1094)modelBuilder).method_4748(arg_0));
                this.children.add(modelBuilder.method_4746());
            }

            private void flushQuads() {
                if (this.quads.size() > 0) {
                    this.addLayer(this.quads);
                    this.quads.clear();
                }
            }

            public Builder setParticle(class_1058 particleSprite) {
                this.particle = particleSprite;
                return this;
            }

            public Builder addQuads(class_777 ... quadsToAdd) {
                this.flushQuads();
                Collections.addAll(this.quads, quadsToAdd);
                return this;
            }

            public Builder addQuads(Collection<class_777> quadsToAdd) {
                this.flushQuads();
                this.quads.addAll(quadsToAdd);
                return this;
            }

            public class_1087 build() {
                if (this.quads.size() > 0) {
                    this.addLayer(this.quads);
                }
                ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
                ImmutableList.Builder itemPassesBuilder = ImmutableList.builder();
                int i = 0;
                for (class_1087 model : this.children) {
                    childrenBuilder.put((Object)("model_" + i++), (Object)model);
                    itemPassesBuilder.add((Object)model);
                }
                return new Baked(this.isGui3d, this.isSideLit, this.isAmbientOcclusion, this.particle, this.transforms, this.overrides, (ImmutableMap<String, class_1087>)childrenBuilder.build(), (ImmutableList<class_1087>)itemPassesBuilder.build());
            }
        }
    }
}

